% Schmitt circuit (Modified Nodal Equations) using Homotopy

clear all
clc

global a
global Gleak
% Initial Guess
Gleak = 0.0016;
a = [0.5000; 0.4799; 0.9047; 0.6099; 0.6177-(1.5/Gleak); 0.8594-(10.0/Gleak); 0.8055; 0.5767];

% Determine a root of the homotopy function when lambda = 0

X0 = fsolve('Schmittinit',a);

% Solve the nonlinear system of equations using ODE-based homotopy,
% with a variable-order variable-step predictor-corrector integration technique

[vs,s,lambda,v,N] = pchomotopy('SchmittJac',X0,2500);

% Plot the trajectory of the variables wrt lambda

plot(lambda,v)
title('Homotopy paths for Schmitt (Modified Nodal Equations)')
xlabel('Lambda')
ylabel('Node Voltages and Currents')
leg = legend('v(1)','v(2)','v(3)','v(4)','v(5)','v(6)','i(vcc)','i(vin)');
set(leg,'Location','NorthWest')
axis([0 1.2 -1 12])
grid 

% Display the final solutions of the nonlinear system of equations

%clc
disp('The final solutions for Schmitt (Modified Nodal Equations) are')
disp('     Sol1      Sol2      sol3    ')
disp(vs)